(*********************************************************************************
* Copyright: Bernecker+Rainer
* Author:    Mikael Regard
* Created:   May 13, 2019/8:21 AM 
* Updated:   Aug 19, 2019/09:00 AM
 *********************************************************************************
 * Description:
 * FuB to Update set position Xbot.
 * 
 *Input:
 * MsgFrame  (Profinet output frame)
 * Execute   (Edgepos, Execute = TRUE will run the FuB once)
 * Cmd Label (Optional 2 byte Command label. Used to identify specfic commands.
 * StreamID[0..9] (Array of StreamID)
 * NumOfStreamID (Number of streams to assign values to).
 * XPos[0..9] (New X Position for specific stream)
 * YPos[0..9] (New Y Position for specific stream)
 * ZPos[0..9] (New Z Position for specific stream)
 * RXPos[0..9] (New RX Position for specific stream)
 * RYPos[0..9] (New RY Position for specific stream)
 * RZPos[0..9] (New RZ Position for specific stream)
 *********************************************************************************)







FUNCTION_BLOCK PM_UpdateSetPos		
	IF(Execute)THEN
		
		FOR count := 0 TO NumOfStreamID DO
			//brsmemset(ADR(msgFrame[76 + 28*streamID]),FALSE,28);
			brsmemcpy(ADR(MsgFrame[76 + (UPDATESETPOS_BYTE_SEQUENCE*StreamID[count])]), ADR(XPos[count]), 4); 	// First byte seq 107:104, StreamID >0, 
			brsmemcpy(ADR(MsgFrame[80 + (UPDATESETPOS_BYTE_SEQUENCE*StreamID[count])]), ADR(YPos[count]), 4);	// First byte seq 111:108, StreamID >0		
			brsmemcpy(ADR(MsgFrame[84 + (UPDATESETPOS_BYTE_SEQUENCE*StreamID[count])]), ADR(ZPos[count]), 4);	// First byte seq 115:112, StreamID >0
			brsmemcpy(ADR(MsgFrame[88 + (UPDATESETPOS_BYTE_SEQUENCE*StreamID[count])]), ADR(RXPos[count]), 4);	// First byte seq 119:116, StreamID >0
			brsmemcpy(ADR(MsgFrame[92 + (UPDATESETPOS_BYTE_SEQUENCE*StreamID[count])]), ADR(RYPos[count]), 4);	// First byte seq 123:120, StreamID >0
			brsmemcpy(ADR(MsgFrame[96 + (UPDATESETPOS_BYTE_SEQUENCE*StreamID[count])]), ADR(RZPos[count]), 4); 	// First byte seq 127:124, StreamID >0      

		END_FOR;
		
	END_IF;		
	
	
	
END_FUNCTION_BLOCK
